# 通知設計書 7-Download Complete

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるダウンロード完了通知「Download Complete」の設計仕様を定義する。この通知は、StaxRipUpdateおよびToolUpdate機能でファイルのダウンロードが正常に完了した際に表示される情報通知である。

### 本通知の処理概要

Download Complete通知は、更新ファイルやツールのダウンロードが成功したことをユーザーに伝達するための通知メカニズムである。

**業務上の目的・背景**：アプリケーションやツールの更新プロセスにおいて、ダウンロードフェーズが正常に完了したことをユーザーにフィードバックする。これにより、ユーザーは更新プロセスの進行状況を把握し、次のステップ（抽出、インストール等）への準備ができる。ダウンロードは時間がかかる処理であるため、完了通知は重要なマイルストーンとなる。

**通知の送信タイミング**：非同期ダウンロード処理のコールバック（AsyncCompletedEventArgs）で、ダウンロードがキャンセルされておらず、エラーも発生していない場合に表示される。

**通知の受信者**：アプリケーションの更新またはツールの更新を実行しているユーザー。

**通知内容の概要**：「Download succeeded!」というシンプルな成功メッセージがMsgInfo形式で表示される。Infoアイコン（青い情報マーク）とOKボタンが配置される。

**期待されるアクション**：ユーザーはダウンロード成功を確認し、OKボタンをクリックしてダイアログを閉じる。その後、更新プロセスの次のステップ（通常は自動的に進行）を待つか、手動で次の操作を行う。

## 通知種別

アプリ内通知（タスクダイアログ/MsgInfo）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック内で表示） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

ダウンロードを開始したフォームまたはメインウィンドウのオーナーとして表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
Download succeeded!

[コンテンツ]
（なし）

[アイコン]
Info（青い情報アイコン）

[ボタン]
OK
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ/非同期処理 | OnDownloadComplete | e.Cancelled = False And e.Error Is Nothing | ダウンロード完了コールバックで成功時に表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| e.Cancelled = True | ダウンロードがキャンセルされた場合は表示しない |
| e.Error IsNot Nothing | ダウンロードエラーが発生した場合は表示しない（代わりにMsgErrorで"Download failed!"を表示） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ダウンロード開始] --> B[非同期ダウンロード処理]
    B --> C[OnDownloadComplete コールバック]
    C --> D{e.Cancelled?}
    D -->|Yes| E[処理終了/通知なし]
    D -->|No| F{e.Error?}
    F -->|IsNot Nothing| G[MsgError Download failed!]
    F -->|Is Nothing| H[MsgInfo Download succeeded!]
    H --> I[ダイアログ表示]
    I --> J{ユーザー操作}
    J -->|OK| K[ダイアログクローズ]
    K --> L[後続処理へ]
    G --> M[エラー処理]
    E --> N[終了]
    L --> N
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Download Completeはデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（Download Completeは送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ダウンロードキャンセル | ユーザーによるキャンセル | 通知を表示せずに終了 |
| ダウンロードエラー | ネットワークエラー等 | MsgErrorで"Download failed!"を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ダウンロード完了時に即座に表示）

## セキュリティ考慮事項

- ダウンロードしたファイルの整合性検証は別途行われる
- 通知自体には機密情報は含まれない

## 備考

- StaxRipUpdate.OnDownloadComplete()内で使用される
- 実際のメッセージは"Download succeeded!"（コード上のtypoがあれば修正要）
- ダウンロード完了後の抽出・インストール処理は別のフローで実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダウンロード完了イベントで使用されるAsyncCompletedEventArgsを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | AsyncCompletedEventArgsの使用（行144-150） |

**読解のコツ**: .NETのAsyncCompletedEventArgsには、Cancelled（キャンセルフラグ）とError（例外）プロパティがあり、これらで処理結果を判定する。

#### Step 2: エントリーポイントを理解する

OnDownloadComplete()コールバック関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | OnDownloadComplete関数の定義（行144-150） |

**主要処理フロー**:
1. **行144**: Shared Sub OnDownloadComplete(sender, e As AsyncCompletedEventArgs)
2. **行145**: Not e.Cancelled AndAlso e.Error Is Nothing の条件チェック
3. **行146**: MsgInfo("Download succeeded!") - 成功時の通知
4. **行148**: MsgError("Download failed!") - 失敗時の通知

#### Step 3: MsgInfo呼び出しを理解する

MsgInfoがどのようにダイアログを表示するかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgInfo関数の定義（行1216-1220） |

**主要処理フロー**:
- **行1216-1220**: MsgInfo関数がMsg関数を呼び出し
- TaskIcon.Info, TaskButton.OKでダイアログを表示

### プログラム呼び出し階層図

```
[ダウンロード開始]
    |
    +-- WebClient.DownloadFileAsync() または HttpClient
           |
           +-- [非同期ダウンロード処理]
                  |
                  +-- OnDownloadComplete(sender, e)  [StaxRipUpdate.vb:144]
                         |
                         +-- e.Cancelled チェック
                         +-- e.Error チェック
                         |
                         +-- (成功時)
                         |      |
                         |      +-- MsgInfo("Download succeeded!")  [StaxRipUpdate.vb:146]
                         |             |
                         |             +-- MsgInfo()  [General.vb:1216]
                         |                    |
                         |                    +-- Msg(title, content, Info, OK)
                         |                           |
                         |                           +-- TaskDialog.Show()
                         |
                         +-- (失敗時)
                                |
                                +-- MsgError("Download failed!")  [StaxRipUpdate.vb:148]
```

### データフロー図

```
[入力]               [処理]                    [出力]

ダウンロード完了 ──> OnDownloadComplete() ──> イベント受信
イベント               |
                       |
AsyncCompleted ──────> 条件判定 ────────────> 分岐
EventArgs              |
    |                  |
    +-- Cancelled ───> False かつ ──────────> MsgInfo表示
    +-- Error ───────> Is Nothing
                       |
                       +── True または ─────> MsgError表示
                           IsNot Nothing      または 終了
                       |
                 MsgInfo呼び出し ──────────> [画面表示]
                       |
             "Download succeeded!" ────────> ダイアログ
                       |
                   OKクリック ─────────────> [クローズ]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ソース | OnDownloadComplete関数、ダウンロード完了通知の発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | 実際のダイアログ表示処理 |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示フォーム |
